package gov.va.med.mhv.usermgmt.form;

import gov.va.med.mhv.usermgmt.enumeration.OrganizationTypeEnumeration;
import gov.va.med.mhv.usermgmt.transfer.Organization;
import gov.va.med.mhv.usermgmt.transfer.Role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

/**
 * The EmployeeOrganizationRoleForm class is responsible for handling user input.
 */
public class EmployeeOrganizationRoleForm extends EmployeeOrganizationRoleBaseForm {
	private Map<Long, Organization> organizations;
	private Map <Long, Role> roles;
		
	protected void doReset(ActionMapping mapping, HttpServletRequest request) { }

	public void setOrganizations(Collection<Organization> organizationsCollection) {
		organizations = new LinkedHashMap<Long, Organization>();		
		for(Organization org:organizationsCollection){
			organizations.put(org.getId(),org);
		}
	}

	public void setRoles(Collection<Role> rolesCollection) {
		roles = new LinkedHashMap<Long, Role>();		
		for(Role role:rolesCollection){
			roles.put(role.getId(),role);
		}
	}
	
	public Collection getOrgTypesSelectOptions(){
		Collection<String> options = new ArrayList<String>();
		for (Map.Entry <Long, Organization> entry : organizations.entrySet()) {
			if(!options.contains(entry.getValue().getTypeOfOrganization().getName()))
				options.add(entry.getValue().getTypeOfOrganization().getName());		
		}		
		return options;
	}
	
	public Map<Long, String> getOrgsOfTypeSelectOptions(){
		Map <Long, String> options = new LinkedHashMap<Long, String>();
		for (Map.Entry <Long, Organization> entry : organizations.entrySet()) {
			if(entry.getValue().getTypeOfOrganization().equals(OrganizationTypeEnumeration.getEnum(getOrganizationType()))
			   && !options.containsKey(entry.getKey())){
				options.put(entry.getKey(),entry.getValue().getName());
			}
		}	
		return options;
	}

	public Map getRoleSelectOptions() {
		Map <Long, String> options = new LinkedHashMap<Long, String>();
		for (Map.Entry <Long, Role> entry : roles.entrySet()) {
			options.put(entry.getKey(),entry.getValue().getName());		
		}
		return options;
	}
	
	public Role getSelectedRole(){
		return roles.get(Long.valueOf(getRoleId()));
	}
	
	public Organization getSelectedOrganization(){
		return organizations.get(Long.valueOf(getOrganizationId()));
	}
}